<?php
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';
$pdo = db();
$settings = $pdo->query('SELECT * FROM settings WHERE id=1')->fetch();
$cats = $pdo->query('SELECT * FROM categories WHERE visible=1 ORDER BY sort_order, id')->fetchAll();
$itemsByCat = [];
if ($cats) {
  $in = implode(',', array_fill(0, count($cats), '?'));
  $stmt = $pdo->prepare("SELECT * FROM items WHERE is_available=1 AND category_id IN ($in) ORDER BY sort_order, id");
  $stmt->execute(array_column($cats, 'id'));
  foreach ($stmt as $row) { $itemsByCat[$row['category_id']][] = $row; }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head><meta charset="utf-8"><title><?= e($settings['restaurant_name']) ?> - المنيو</title></head>
<body>
<h1><?= e($settings['restaurant_name']) ?> - المنيو</h1>
<?php foreach ($cats as $c): ?>
  <h2><?= e($c['name_ar']) ?></h2>
  <ul>
    <?php foreach ($itemsByCat[$c['id']] ?? [] as $it): ?>
      <li><?= e($it['name_ar']) ?> - <?= e($it['price']) ?> <?= e($settings['currency']) ?></li>
    <?php endforeach; ?>
  </ul>
<?php endforeach; ?>
</body></html>
