<?php
require_once __DIR__ . '/../core/auth.php'; 
require_login(); // منع الدخول لغير المسجلين

$pdo = db();
$stmt = $pdo->query("SELECT * FROM restaurants ORDER BY id DESC LIMIT 1");
$restaurant = $stmt->fetch();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>لوحة التحكم</title>

  <!-- Bootstrap & FontAwesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <style>
    :root{
      /* ألوان افتراضية (الوضع الفاتح) */
      --bg: #f5f7fa;
      --text: #1f2937;
      --muted: #6b7280;
      --card-bg: #ffffff;
      --card-border: rgba(0,0,0,0.06);
      --brand-1: #0f2027;
      --brand-2: #203a43;
      --brand-3: #2c5364;
      --primary: #1abc9c;
      --primary-600:#16a085;
      --link:#3498db;

      --sidebar-bg:#2f3b46;
      --sidebar-item:#e8eef3;
      --sidebar-item-hover:#1abc9c;
      --sidebar-head:#22303a;
    }
    body.dark{
      /* ألوان الوضع الليلي */
      --bg: #0f1115;
      --text: #e5e7eb;
      --muted: #9ca3af;
      --card-bg: #151922;
      --card-border: rgba(255,255,255,0.08);
      --brand-1:#000;
      --brand-2:#111;
      --brand-3:#222;
      --primary:#16a085;
      --primary-600:#149174;
      --link:#60a5fa;
      --sidebar-bg:#141a22;
      --sidebar-item:#c7d2fe;
      --sidebar-item-hover:#1abc9c;
      --sidebar-head:#0f141a;
    }

    /* Reset & Base */
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0;
      background:var(--bg);
      color:var(--text);
      font-family:"Tajawal", Tahoma, Arial, sans-serif;
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
    }
    a{color:var(--link); text-decoration:none}
    a:hover{text-decoration:underline}

    /* Header */
    header{
      background: linear-gradient(135deg,var(--brand-1),var(--brand-2),var(--brand-3));
      color:#fff;
      padding:14px 18px;
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:12px;
      box-shadow:0 6px 24px rgba(0,0,0,.25);
      position:sticky;
      top:0;
      z-index:1000;
    }
    header .title{
      display:flex; align-items:center; gap:10px; justify-content:center; flex:1;
      font-size:20px; font-weight:800; letter-spacing:.3px;
    }
    .user-info{
      display:flex; align-items:center; gap:10px;
      background:rgba(255,255,255,.1);
      padding:6px 10px; border-radius:999px;
      transition:.25s;
    }
    .user-info:hover{ background:rgba(255,255,255,.2); }
    .user-info img{
      width:36px; height:36px; border-radius:50%; object-fit:cover; border:2px solid var(--primary);
    }
    .user-info .name{ font-weight:700; font-size:13px; }
    .user-info .logout{
      background:#e74c3c; color:#fff; border:none; padding:6px 10px;
      border-radius:999px; font-size:12px; text-decoration:none;
    }
    .user-info .logout:hover{ background:#c0392b; }

    #darkSwitch{
      background:var(--primary);
      color:#fff; border:0; border-radius:999px; padding:8px 12px; font-weight:800; cursor:pointer;
      box-shadow:0 4px 12px rgba(0,0,0,.25);
    }
    #darkSwitch:hover{ background:var(--primary-600); }

    /* Layout */
    .wrap{
      display:flex; gap:18px;
      flex-direction: row-reverse; /* يخلي السايدبار يمين */
      padding:18px;
      min-height: calc(100vh - 64px);
    }

    /* Sidebar */
    .sidebar{
      width:280px; flex:0 0 280px;
      background:var(--sidebar-bg);
      border-radius:14px; padding:10px; color:#fff;
      height:fit-content; position:sticky; top:90px;
      box-shadow:0 10px 24px rgba(0,0,0,.18);
    }
    .sidebar .accordion-item{
      border:none; background:transparent; color:#fff; margin-bottom:8px;
    }
    .sidebar .accordion-button{
      background:var(--sidebar-head); color:#fff; border:none; border-radius:10px !important;
      padding:10px 12px; font-weight:800;
    }
    .sidebar .accordion-button:focus{ box-shadow:none; }
    .sidebar .accordion-button:not(.collapsed){
      background:var(--primary); color:#fff;
    }
    .sidebar .accordion-body{ padding:0 !important; }
    .sidebar .list-group{ border-radius:10px; overflow:hidden; }
    .sidebar .list-group-item{
      background:transparent; color:var(--sidebar-item);
      border:0; display:flex; align-items:center; gap:10px;
      padding:10px 14px; transition:.2s;
    }
    .sidebar .list-group-item:hover{
      background:rgba(255,255,255,.06); color:#fff;
    }
    .sidebar .list-group-item a{
      color:inherit; text-decoration:none; flex:1;
    }

    /* Main */
    main{ flex:1; }
    .page-head{
      display:flex; align-items:center; justify-content:space-between; gap:10px; margin-bottom:14px;
    }
    .page-head h2{ margin:0; font-size:20px; font-weight:800; }

    /* Cards (موحّدة الشكل) */
    .cards{
      display:grid; gap:18px;
      grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    }
    .card-tile{
      background:var(--card-bg);
      border:1px solid var(--card-border);
      border-radius:16px;
      padding:16px;
      text-align:center;
      transition: transform .15s ease, box-shadow .2s ease, border-color .2s ease;
      box-shadow: 0 4px 14px rgba(0,0,0,.06);
    }
    .card-tile:hover{
      transform: translateY(-4px);
      box-shadow: 0 12px 30px rgba(0,0,0,.12);
      border-color: rgba(0,0,0,.12);
    }
    .tile-icon{
      width:64px; height:64px; border-radius:14px; display:flex; align-items:center; justify-content:center;
      margin:0 auto 10px auto; font-size:24px; color:#fff;
      background: linear-gradient(135deg, var(--primary), var(--primary-600));
    }
    .tile-title{ font-weight:800; color:var(--text); margin:8px 0 4px; }
    .tile-desc{ color:var(--muted); font-size:13px; min-height:34px; }
    .tile-action{
      display:inline-block; margin-top:10px; padding:8px 12px; border-radius:10px; font-weight:800;
      background:var(--primary); color:#fff; text-decoration:none;
    }
    .tile-action:hover{ background:var(--primary-600); color:#fff; text-decoration:none; }

    /* صورة شعار المطعم داخل نفس شكل الكارت (موحّد) */
    .tile-logo{
      width:64px; height:64px; border-radius:50%; object-fit:cover; border:3px solid var(--primary);
      display:block; margin:0 auto 10px;
    }

    /* Responsive: على الشاشات الصغيرة خليه عمود */
    @media (max-width: 992px){
      .wrap{ flex-direction:column; }
      .sidebar{ position:static; width:100%; flex:none; }
    }
  </style>
</head>
<body>

<header>
  <!-- يمين: المستخدم -->
  <div class="user-info">
    <img src="uploads/<?= htmlspecialchars($_SESSION['avatar'] ?? 'default.png') ?>" alt="Avatar">
    <span class="name"><?= htmlspecialchars($_SESSION['admin_username']) ?></span>
    <a class="logout" href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> خروج</a>
  </div>

  <!-- وسط: العنوان -->
  <div class="title"><i class="fa-solid fa-gauge-high"></i> لوحة التحكم</div>

  <!-- شمال: وضع ليلي -->
  <button id="darkSwitch">🌙</button>
</header>

<div class="wrap">

  <!-- Sidebar (يمين) -->
  <aside class="sidebar">
    <div class="accordion" id="menuAccordion">

      <!-- بيانات أساسية (مفتوحة افتراضيًا) -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingBasic">
          <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseBasic" aria-expanded="true" aria-controls="collapseBasic">
            📊 بيانات أساسية
          </button>
        </h2>
        <div id="collapseBasic" class="accordion-collapse collapse show" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-store"></i><a href="restaurantInfo.php">بيانات المطعم</a></li>
              <li class="list-group-item"><i class="fa-solid fa-code-branch"></i><a href="branches.php">الفروع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-user-group"></i><a href="customers.php">العملاء</a></li>
              <li class="list-group-item"><i class="fa-solid fa-id-badge"></i><a href="employees.php">الموظفين</a></li>
              <li class="list-group-item"><i class="fa-solid fa-users-gear"></i><a href="users.php">المستخدمين</a></li>
              <li class="list-group-item"><i class="fa-solid fa-layer-group"></i><a href="usergroups.php">المجاميع و الصلاحيات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-location-dot"></i><a href="governates.php">المحافظات و أسعار التوصيل</a></li>
              <li class="list-group-item">
                <i class="fa-solid fa-diagram-project me-2"></i>
                <a href="restaurant_layout.php">ادوار و سكاشن وتربيزات</a>
              </li>
              <li class="list-group-item">
                <i class="fa-solid fa-chair me-2"></i>
                <a href="tables_view.php">عرض التربيزات</a>
              </li>
          
            </ul>
          </div>
        </div>
      </div>

      <!-- POS -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingPOS">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePOS" aria-expanded="false" aria-controls="collapsePOS">
            💻 POS
          </button>
        </h2>
        <div id="collapsePOS" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-bag-shopping"></i><a href="pos/takeaway.php">تيك أواي</a></li>
              <li class="list-group-item"><i class="fa-solid fa-chair"></i><a href="pos/dinein.php">صالة</a></li>
              <!-- الجديد: حجز صالة -->
              <li class="list-group-item">
                <i class="fa-solid fa-calendar-check me-2"></i>
                <a href="reservations.php">حجز صالة</a>
              </li>
            
            </ul>
          </div>
        </div>
      </div>

      <!-- الأصناف -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingItems">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseItems" aria-expanded="false" aria-controls="collapseItems">
            🍔 الأصناف
          </button>
        </h2>
        <div id="collapseItems" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-folder-tree"></i><a href="groups.php">الأقسام و المجاميع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-burger"></i><a href="items.php">الأصناف</a></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- التشغيل -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingOps">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOps" aria-expanded="false" aria-controls="collapseOps">
            📅 التشغيل
          </button>
        </h2>
        <div id="collapseOps" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-calendar-day"></i><a href="dailyshifts.php">اليوميات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-clock-rotate-left"></i><a href="cashier_shift.php">الشيفتات</a></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- الإعدادات -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingSettings">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSettings" aria-expanded="false" aria-controls="collapseSettings">
            ⚙️ إعدادات
          </button>
        </h2>
        <div id="collapseSettings" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-sliders"></i><a href="settings.php">الإعدادات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-right-from-bracket"></i><a href="logout.php">تسجيل الخروج</a></li>
            </ul>
          </div>
        </div>
      </div>

    </div>
  </aside>

  <!-- Main (شمال) -->
  <main>
    <div class="page-head">
      <h2>مرحباً بك في لوحة التحكم</h2>
    </div>

    <div class="cards">

      <!-- كارت بيانات المطعم (موحّد الشكل) -->
      <div class="card-tile">
        <?php if ($restaurant && !empty($restaurant['Logo'])): ?>
          <img class="tile-logo" src="uploads/<?= htmlspecialchars($restaurant['Logo']) ?>" alt="شعار المطعم">
        <?php else: ?>
          <div class="tile-icon"><i class="fa-solid fa-store"></i></div>
        <?php endif; ?>
        <div class="tile-title"><?= htmlspecialchars($restaurant['CompanyName'] ?? 'بيانات المطعم') ?></div>
        <div class="tile-desc">
          <?= htmlspecialchars($restaurant['CompanyEName'] ?? 'إدارة معلومات المطعم') ?>
          <?php if (!empty($restaurant['Phone'])): ?><br>📞 <?= htmlspecialchars($restaurant['Phone']) ?><?php endif; ?>
          <?php if (!empty($restaurant['Website'])): ?><br>🌐 <a href="<?= htmlspecialchars($restaurant['Website']) ?>" target="_blank"><?= htmlspecialchars($restaurant['Website']) ?></a><?php endif; ?>
        </div>
        <a class="tile-action" href="restaurantInfo.php">إدارة</a>
      </div>

      <!-- كروت موحّدة -->
      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-folder-tree"></i></div>
        <div class="tile-title">إدارة الأقسام و المجاميع</div>
        <div class="tile-desc">إضافة وتعديل وحذف الأقسام والمجاميع</div>
        <a class="tile-action" href="groups.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-burger"></i></div>
        <div class="tile-title">إدارة الأصناف</div>
        <div class="tile-desc">إضافة وتعديل وحذف الأصناف</div>
        <a class="tile-action" href="items.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-bag-shopping"></i></div>
        <div class="tile-title">الطلبات</div>
        <div class="tile-desc">متابعة وإدارة الطلبات</div>
        <a class="tile-action" href="orders.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-users-gear"></i></div>
        <div class="tile-title">المستخدمون</div>
        <div class="tile-desc">إدارة حسابات المستخدمين</div>
        <a class="tile-action" href="users.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-user-shield"></i></div>
        <div class="tile-title">المجاميع و الصلاحيات</div>
        <div class="tile-desc">تنظيم الصلاحيات حسب المجموعات</div>
        <a class="tile-action" href="usergroups.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-sliders"></i></div>
        <div class="tile-title">الإعدادات</div>
        <div class="tile-desc">تخصيص إعدادات النظام</div>
        <a class="tile-action" href="settings.php">إدارة</a>
      </div>

    </div>
  </main>

</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // وضع ليلي (محفوظ في LocalStorage)
  const body = document.body;
  const darkSwitch = document.getElementById("darkSwitch");
  if(localStorage.getItem("darkMode") === "true"){
    body.classList.add("dark");
    darkSwitch.textContent = "☀️";
  }
  darkSwitch.addEventListener("click", () => {
    body.classList.toggle("dark");
    const isDark = body.classList.contains("dark");
    localStorage.setItem("darkMode", isDark);
    darkSwitch.textContent = isDark ? "☀️" : "🌙";
  });
</script>

</body>
</html>
