<?php
require_once __DIR__ . '/../core/auth.php';
require_login();
$pdo = db();

// جلب المجموعات
$groups = $pdo->query("SELECT Code, CName FROM Categories ORDER BY SortOrder, Code")->fetchAll();

// جلب الأصناف (هنحتاجهم بالـ group_id)
$items = $pdo->query("SELECT Code, IName, PriceTW, Cat_Code FROM Items ORDER BY Cat_Code")->fetchAll(PDO::FETCH_GROUP|PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>💳 مبيعات الوجبات السريعة</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { font-family:"Tajawal",sans-serif; background:#f8f9fa; }
    .group-btn, .item-btn {
      margin:5px; border-radius:12px; font-weight:bold;
    }
    .group-btn { background:linear-gradient(135deg,#2c3e50,#3498db); color:#fff; }
    .item-btn { background:linear-gradient(135deg,#27ae60,#2ecc71); color:#fff; }
    .item-btn:hover, .group-btn:hover { opacity:0.85; }
    table { background:#fff; border-radius:10px; }
    tfoot td { font-size:1.2rem; font-weight:bold; color:#d35400; }
  </style>
</head>
<body>
<div class="container py-4">
  <h2 class="mb-4">🍔💳 شاشة مبيعات الوجبات السريعة</h2>

  <!-- أزرار المجموعات -->
  <div class="mb-3">
    <?php foreach ($groups as $g): ?>
      <button class="btn group-btn" onclick="showItems(<?= $g['Code'] ?>)">
        <?= htmlspecialchars($g['CName']) ?>
      </button>
    <?php endforeach; ?>
  </div>

  <!-- أزرار الأصناف -->
  <div id="itemsContainer" class="mb-4"></div>

  <!-- جدول الفاتورة -->
  <table class="table table-bordered text-center align-middle" id="invoiceTable">
    <thead class="table-dark">
      <tr>
        <th>الصنف</th>
        <th>الكمية</th>
        <th>السعر</th>
        <th>القيمة</th>
        <th>❌</th>
      </tr>
    </thead>
    <tbody></tbody>
    <tfoot>
      <tr>
        <td colspan="3">الإجمالي</td>
        <td id="total">0.00</td>
        <td></td>
      </tr>
    </tfoot>
  </table>
</div>

<script>
  // الأصناف من PHP
  const itemsByGroup = <?= json_encode($items, JSON_UNESCAPED_UNICODE) ?>;
  const invoice = {};

  function showItems(groupId) {
    const container = document.getElementById("itemsContainer");
    container.innerHTML = "";
    (itemsByGroup[groupId] || []).forEach(item => {
      const btn = document.createElement("button");
      btn.className = "btn item-btn";
      btn.textContent = item.IName + " - " + item.PriceTW + " ج";
      btn.onclick = () => addItem(item);
      container.appendChild(btn);
    });
  }

  function addItem(item) {
    if (!invoice[item.Code]) {
      invoice[item.Code] = {name: item.IName, qty: 0, price: parseFloat(item.PriceTW)};
    }
    invoice[item.Code].qty++;

    renderInvoice();
  }

  function removeItem(code) {
    delete invoice[code];
    renderInvoice();
  }

  function renderInvoice() {
    const tbody = document.querySelector("#invoiceTable tbody");
    tbody.innerHTML = "";
    let total = 0;

    Object.values(invoice).forEach(row => {
      const value = row.qty * row.price;
      total += value;
      tbody.innerHTML += `
        <tr>
          <td>${row.name}</td>
          <td>${row.qty}</td>
          <td>${row.price.toFixed(2)}</td>
          <td>${value.toFixed(2)}</td>
          <td><button class="btn btn-sm btn-danger" onclick="removeItem(${row.code})">❌</button></td>
        </tr>
      `;
    });

    document.getElementById("total").textContent = total.toFixed(2);
  }
</script>
</body>
</html>
